/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#include <data.h>
#include <Dialog.h>
#include <utilities.h>
#include <math.h>
#include <stdio.h>
#include "nitestRes.h"	// Resource header file


class CNiTestDlg : public Dialog
{
public:
	CNiTestDlg() : Dialog(IDD_NI_GRAPH3D, "NiTest")
	{
		
	}
	
	virtual int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_ACTIVEX_EVENT(1, IDC_CWKNOB1, OnPtrValueChange, VTS_CTRL VTS_I4 VTS_PVARIANT)
	ON_ACTIVEX_EVENT(-607, IDC_CWKNOB1, OnKnobMouseUp, VTS_CTRL VTS_I2 VTS_I2 VTS_I4 VTS_I4)
	ON_ACTIVEX_EVENT(-607, IDC_CWSLIDE1, OnSlideMouseUp, VTS_CTRL VTS_I2 VTS_I2 VTS_I4 VTS_I4)
EVENTS_END
	
	void FillMatrixWithValues(Matrix& myMat, double x0, double y0, double A, double w, double dNoise = 1.0)
	{
		int nRows = myMat.GetNumRows();
		int nCols = myMat.GetNumCols();
		int nX0 = x0 * nRows;
		int nY0 = y0 * nCols;
		w *= 2. * PI * (nRows + nCols);
		
		for(int ii = 0; ii < nCols; ii++)
		{
			for(int jj = 0; jj < nRows; jj++)
			{
				double rsq = (ii - nY0)^2. + (jj - nX0)^2.0;
				myMat[ii][jj] = rnd()*dNoise + A * exp(-rsq/w);
			}
		}
	}
	

	BOOL OnInitDialog()
	{
		// make all interface controls as data member, and initialize them here
		m_objCW3DGraph1 = GetItem(IDC_CWGRAPH3D1).GetActiveXControl();
		m_objCWKnob1 = GetItem(IDC_CWKNOB1).GetActiveXControl();
		m_objCWSlide1 = GetItem(IDC_CWSLIDE1).GetActiveXControl();	
		
		Matrix myMat("Matrix1");
		if(!myMat)
		{
			MatrixLayer mlTemp;
			mlTemp.Create();
			myMat.Attach(mlTemp);
			
			// need to fill with values if creating new
			FillMatrixWithValues(myMat, 0.2, 0.4, 15.0, 0.3);
			mlTemp.GetPage().GetName(m_strMatLayerName);//save for destroy later
		}
		else
			m_strMatLayerName.Empty();
			
		
		if(myMat)
		{
			_VARIANT	var = myMat;
			m_objCW3DGraph1.Plot3DSimpleSurface(var);
		}
		
		return TRUE;
	}
	
	
	BOOL OnDestroy(void)
	{
		if(!m_strMatLayerName.IsEmpty())
		{
			MatrixPage mpg(m_strMatLayerName);
			mpg.Destroy();
		}
		return true;
	}
	
	
	void OnPtrValueChange(Control cntrl, int nPtr, _VARIANT& var)
	{
		//out_int("nPtr = ", nPtr);
	}
	
	
	void UpdateMatrixGraph()
	{
		Matrix myMat(m_strMatLayerName);
		
		if(myMat)
		{
			double dNoiseLevel = m_objCWKnob1.Value;
			
			double vv = m_objCWSlide1.Value;
			double dPeakHalfWidth = 5. / (vv+1.);
			FillMatrixWithValues(myMat, 0.2, 0.4, 15.0, dPeakHalfWidth, dNoiseLevel);
			
			_VARIANT	var = myMat;
			m_objCW3DGraph1.Plot3DSimpleSurface(var);
		}
	}
	
	
	// when change the knob, the graph will change as follow.
	void OnKnobMouseUp(Control cntrl, short nButton, short Shift, long x, long y)
	{
		UpdateMatrixGraph();	
	}
	
	
	// when change the slide, the graph will change as follow.
	void OnSlideMouseUp(Control cntrl, short nButton, short Shift, long x, long y)
	{
		UpdateMatrixGraph();	
	}
	
	
private:	
	string m_strMatLayerName;
	
	// control objects, these are NI ActiveX controls
	Object m_objCW3DGraph1;	
	Object m_objCWKnob1;
	Object m_objCWSlide1;

};
